--T-SQL Window Function Deep Dive
--1. Ranking Queries

USE AdventureWorks2014;
GO

--Ranking functions introduced in 2005 with the OVER clause
SELECT  SalesOrderID, OrderDate, CustomerID, 
	ROW_NUMBER() OVER(ORDER BY SalesOrderID) AS RowNbr
FROM Sales.SalesOrderHeader;

--you can also partition the results
SELECT SalesOrderID, OrderDate, CustomerID, 
	ROW_NUMBER() OVER(Partition By CustomerID ORDER BY SalesOrderID) 
	AS RowNbr
FROM Sales.SalesOrderHeader;

--What's the difffence between ROW_NUMBER, RANK and DENSE_RANK?
SELECT SalesOrderID, OrderDate, CustomerID, 
	ROW_NUMBER() OVER(PARTITION BY CustomerID ORDER BY OrderDate) As RowNum,
	RANK() OVER(PARTITION BY CustomerID ORDER BY OrderDate) As Rnk,
	DENSE_RANK() OVER(PARTITION BY CustomerID ORDER BY OrderDate) As DenseRnk
FROM Sales.SalesOrderHeader
WHERE CustomerID = 11078;

--NTILE
SELECT SP.FirstName, SP.LastName,
	SUM(SOH.TotalDue) AS TotalSales, 
	NTILE(4) OVER(ORDER BY SUM(SOH.TotalDue)) * 1000 AS Bonus
FROM [Sales].[vSalesPerson] SP 
JOIN Sales.SalesOrderHeader SOH ON SP.BusinessEntityID = SOH.SalesPersonID 
WHERE SOH.OrderDate >= '2011-01-01' AND SOH.OrderDate < '2012-01-01'
GROUP BY FirstName, LastName;

--ROW_NUMBER is non-deterministic
SELECT SalesOrderID, OrderDate, ROW_NUMBER() OVER(ORDER BY OrderDate) AS RowNum
FROM Sales.SalesOrderHeader
WHERE CustomerID = 11078
ORDER BY SalesOrderID;

SELECT SalesOrderID, OrderDate, ROW_NUMBER() OVER(ORDER BY OrderDate) AS RowNum
FROM Sales.SalesOrderHeader
WHERE CustomerID = 11078
ORDER BY OrderDate, SalesOrderID DESC;



--How to get unordered row numbers
SELECT CustomerID, SalesOrderID, OrderDate, 
	ROW_NUMBER() OVER(ORDER BY (SELECT NULL)) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY CustomerID;

SELECT CustomerID, SalesOrderID, OrderDate, 
	ROW_NUMBER() OVER(ORDER BY (SELECT NULL)) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY SalesOrderID;

--Random 
SELECT CustomerID, SalesOrderID, OrderDate, 
	ROW_NUMBER() OVER(ORDER BY NEWID()) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY CustomerID;




--Top 
SELECT TOP(10) CustomerID, 
	SalesOrderID, 
	ROW_NUMBER() OVER(ORDER BY SalesOrderID) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY CustomerID;

--Distinct
SELECT DISTINCT CustomerID, 
	ROW_NUMBER() OVER(ORDER BY CustomerID) AS RowNum
FROM Sales.SalesOrderHeader
ORDER BY CustomerID;

WITH Cust AS (
	SELECT DISTINCT CustomerID 
	FROM Sales.SalesOrderHeader)
SELECT CustomerID, ROW_NUMBER() OVER(ORDER BY CustomerID) AS RowNum
FROM Cust
ORDER BY CustomerID;


